import 'dart:async';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_inappwebview/flutter_inappwebview.dart';
import 'package:road24_mobile/model/utils/Config.dart';
import 'package:road24_mobile/model/utils/styles/AppColors.dart';
import 'package:road24_mobile/model/utils/styles/AppStyles.dart';
import 'package:webview_flutter/webview_flutter.dart';

class WebViewOfManual extends StatefulWidget {
  final String appBarTitle;
  final String pathOfHTML;

  const WebViewOfManual(
      {Key? key, required this.pathOfHTML, required this.appBarTitle})
      : super(key: key);

  @override
  _WebViewOfManualState createState() => _WebViewOfManualState();
}

class _WebViewOfManualState extends State<WebViewOfManual> {
  final Completer<WebViewController> _controller =
      Completer<WebViewController>();
  String languagePath = Config.language.toUpperCase();
  String data = "";
  String dir = "";
  String url = "";
  InAppWebViewController? _webViewController;
  @override
  void initState() {
    // loadAssets();
    super.initState();
  }

  Future<String> loadAssets() async {
    data = await rootBundle.loadString(
      "assets/html/manual/${widget.pathOfHTML}",
    );
    return data;
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
        backgroundColor: AppColors.appPrimaryColor,
        appBar: AppBar(
          toolbarHeight: 60.0,
          leading: Material(
            type: MaterialType.transparency,
            child: InkWell(
              onTap: () => Navigator.pop(context),
              child: Container(
                margin: const EdgeInsets.all(10.0),
                decoration: const BoxDecoration(
                  color: Color(0xffDFDFDF),
                  shape: BoxShape.circle,
                ),
                child: const Center(
                  child: Icon(
                    Icons.arrow_back_ios_outlined,
                    size: 20.0,
                    color: Colors.black,
                  ),
                ),
              ),
            ),
          ),
          title: Text(
            widget.appBarTitle,
            style: AppStyle.textStyle().copyWith(
                color: Colors.black,
                fontWeight: FontWeight.w600,
                fontSize: 21.0),
          ),
        ),
        body: body());
  }

  double progress = 0;
  body() {
    return FutureBuilder<String>(
        future: loadAssets(),
        builder: (context, snapshot) {
          // if (snapshot.connectionState == ConnectionState.waiting) {
          //   return CupertinoActivityIndicator();
          // }
          if (snapshot.hasData) {
            return SafeArea(
              child: Container(
                color: AppColors.appPrimaryColor,
                margin: const EdgeInsets.all(10.0),
                child: InAppWebView(
                  // initialUrl: "https://youtube.com/",
                  initialFile: "assets/html/manual/${widget.pathOfHTML}",

                  onWebViewCreated: (InAppWebViewController controller) {
                    _webViewController = controller;
                  },

                  onLoadStart: (InAppWebViewController controller, Uri? url) {
                    if (url != null)
                      setState(() {
                        this.url = url.path;
                      });
                  },
                  onLoadStop:
                      (InAppWebViewController controller, Uri? url) async {
                    if (url != null)
                      setState(() {
                        this.url = url.path;
                      });
                  },
                  onProgressChanged:
                      (InAppWebViewController controller, int progress) {
                    setState(() {
                      this.progress = progress / 100;
                    });
                  },
                ),
              ),
            );
          }
          return const Center(child: CupertinoActivityIndicator());
        });
  }
}
